<?php

namespace App\Models\Dashboard;

use App\Traits\HasJsonTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AboutStruct extends Model
{
    use HasJsonTranslations, HasFactory;

    protected $table = 'about_structs';

    protected $fillable = [
        'name',
        'long_desc',
        'icon',
        'image',
        'alt_icon',
        'order',
        'status',
    ];

    protected $casts = [
        'name' => 'array',
        'long_desc' => 'array',
    ];

    public function getNameAttribute()
    {
        return $this->getTranslatableAttribute('name');
    }

    public function getLongDescAttribute()
    {
        return $this->getTranslatableAttribute('long_desc');
    }

    public function getIconPathAttribute()
    {
        return $this->attributes['icon'] ? asset('storage/about_structs/' . $this->attributes['icon']) : asset('assets/dashboard/images/noimage.png');
    }
    
    public function getImagePathAttribute()
    {
        return $this->attributes['image'] ? asset('storage/about_structs/' . $this->attributes['image']) : asset('assets/dashboard/images/noimage.png');
    }

    public function scopeActive($query)
    {
        $query->where('status', 1);
    }
}
