<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        
        
        return [
            'id' => $this->id,
            'name' => $this->name,
            'short_desc' => $this->short_desc,
            'long_desc' => $this->long_desc,
            'image' => $this->image_path,
             'pdfs' =>  PdfResource::collection($this->pdfs),
             'youtube_link' => $this->youtube_link,
             'video_desc' => $this->video_desc ,
            'alt_image' => $this->alt_image,
            'icon' => $this->icon_path,
            'alt_icon'=>$this->alt_icon,
            'category_id' => $this->category_id,
            'category_name' => $this->category?->name,
            'slug' => $this->slug_lang,
            'images'=> $this->images->map(fn($image)=>[ 'image' => $image->image_path,'title' => $image->title]),
            'tabs' =>  BenefitResource::collection($this->tabs) ,
             'tabs' =>  BenefitResource::collection($this->tabs) ,
        ];
    }
}
