<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AboutUSResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'subtitle' => $this->title_2,
            'text' => $this->text,
            'image' => $this->image_path, 
            'banner' => $this->banner_path,
            'alt_image' => $this->alt_image,
            'alt_banner' => $this->alt_banner,
            'short_desc' => $this->short_desc,
            'long_desc' => $this->long_desc,
            
        ];
    }
}
