<?php

namespace App\Http\Requests\Dashboard\Features;

use Illuminate\Foundation\Http\FormRequest;

class DeleteFeatureRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'selectedIds' => ['array', 'min:1'],
            'selectedIds.*' => ['exists:features,id']
        ];
    }

    protected function prepareForValidation()
    {
        $feature = $this->route('feature');
        $featureId = is_object($feature) ? $feature->id : $feature;

        // If no selectedIds from request, use the single feature ID
        if (!$this->has('selectedIds') || empty($this->input('selectedIds'))) {
            $this->merge([
                'selectedIds' => [$featureId]
            ]);
        }
    }
}
