<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Http\Requests\TeamRequest;
use App\Models\Team;
use App\Services\Dashboard\TeamService;
use Illuminate\Http\Request;

class TeamController extends Controller
{
    protected $teamService;

    public function __construct(TeamService $teamService)
    {
        $this->teamService = $teamService;

        // Spatie permissions
        $this->middleware('permission:teams.view')->only(['index']);
        $this->middleware('permission:teams.create')->only(['create', 'store']);
        $this->middleware('permission:teams.update')->only(['edit', 'update']);
        $this->middleware('permission:teams.delete')->only(['destroy']);
    }

    public function index()
    {
        $teams = Team::latest()->get();
        return view('Dashboard.Teams.index', compact('teams'));
    }

    public function create()
    {
        return view('Dashboard.Teams.create');
    }

    public function store(TeamRequest $request)
    {
        $this->teamService->store($request);
        return redirect()->route('dashboard.teams.index')->with('success', __('Team created successfully.'));
    }

    public function edit(Team $team)
    {
        return view('Dashboard.Teams.edit', compact('team'));
    }

    public function update(TeamRequest $request, Team $team)
    {
        $this->teamService->update($request, $team);
        return redirect()->route('dashboard.teams.index')->with('success', __('Team updated successfully.'));
    }

    public function destroy(Team $team)
    {
        $this->teamService->delete($team->id);
        return redirect()->route('dashboard.teams.index')->with('success', __('Team deleted successfully.'));
    }
}
