<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Http\Requests\Dashboard\Phones\StorePhoneRequest;
use App\Http\Requests\Dashboard\Phones\UpdatePhoneRequest;
use App\Models\Phone;
use Illuminate\Http\Request;
use App\Services\Dashboard\PhoneService;

// Cache-related imports removed since cache is disabled

class PhoneController extends Controller
{
    // No need for constructor - global NoCacheMiddleware handles all caching
    protected $phoneService;

    public function __construct(PhoneService $phoneService)
    {
        $this->phoneService = $phoneService;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $phones = Phone::latest()->paginate(10);
        return view('Dashboard.Phones.index', compact('phones'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('Dashboard.Phones.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePhoneRequest $request)
    {
         $response = $this->phoneService->store($request);

       if(!$response){
           return redirect()->back()->with(['error' => __('dashboard.failed_to_create_item')]);
       }

        return redirect()->route('dashboard.phones.index')->with('success', 'تم إضافة الهاتف بنجاح');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $phone = Phone::findOrFail($id);
        return view('Dashboard.Phones.show', compact('phone'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $phone = Phone::findOrFail($id);
        return view('Dashboard.Phones.edit', compact('phone'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatePhoneRequest $request,  $id)
    {
        $phone = Phone::findOrFail($id);
        $response = $this->phoneService->update($request, $phone);

        if (!$response) {
            return redirect()->back()->with(['error' => __('dashboard.failed_to_update_item')]);
        }

        return redirect()->route('dashboard.phones.index')->with('success', 'تم تحديث الهاتف بنجاح');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        $selectedIds = $request->input('selectedIds', [$id]);
        $deleted = $this->phoneService->delete($selectedIds);

        if (request()->ajax()) {
                return response()->json([
                    'success' => true,
                    'message' => __('dashboard.your_items_deleted_successfully')
                ]);
            }


        // No cache clearing needed - cache is disabled

        return redirect()->route('dashboard.phones.index')->with('success', 'تم حذف الهاتف بنجاح');
    }

    /**
     * Remove multiple resources from storage.
     */
 

    // clearAllCaches method removed - cache is completely disabled
}
