<?php

namespace App\Http\Controllers\Apis;

use App\Http\Controllers\Controller;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\ProductResource;
use App\Models\Category;
use App\Models\Product;
use App\Models\Section;
use Illuminate\Http\Request;
use App\View\Composers\SeoComposer ;
use Illuminate\Support\Facades\View;

class ProductController extends Controller
{
     private $sections ;
    public function __construct(){
        $this->sections = Section::get();
    }
    public function index()
    {
        SeoComposer::renderSeo();

        $data = [
            'seo' => config('seo'),
            'success' => true,
            'message' => '',
            'data' => [
            'categories' => $this->getCategoriesSection(),
            'products' => $this->getProductsSection(),
            ]

        ];

        return response()->json(
            $data ,
            200,
            
        );
    }

    public function show($id)
    {
        SeoComposer::renderSeo();

        $data = [
            'seo' => config('seo'),
            'success' => true,
            'message' => '',
            'data' => [
            'product' => $this->getProductSection($id),
            ]
        ];

        return response()->json(
            $data ,
            200,
            
        );
    }




    public function getCategoriesSection()
    {
        $category = Category::active()->orderBy('order')->get(['id','name']);

        return [
            'data' =>  $category,
        ];
    }

    public function getProductsSection()
    {
        $section = $this->sections->firstWhere('key' , 'products');
        $product = Product::active()->orderBy('order')->with('tabs','images','video')->get();

        return [
            'title' => $section->title?? null,
            'short_desc' => $section->short_desc?? null,
            'data' => ProductResource::collection($product)

        ];
    }


    public function getProductSection($slug)
    {
        $locales = config('laravellocalization.supportedLocales')
            ? array_keys(config('laravellocalization.supportedLocales'))
            : ['en', 'ar']; // fallback if no localization package
        
        $product = Product::where(function ($query) use ($slug, $locales) {
            foreach ($locales as $locale) {
                $query->orWhereRaw(
                    "JSON_UNQUOTE(JSON_EXTRACT(JSON_UNQUOTE(slug), '$.\"$locale\"')) = ?",
                    [$slug]
                );
            }
        })->with('tabs','images','video')->first();

        if(!$product)abort(404 , 'Page Not Found');

        return [
            'data' =>new ProductResource($product)

        ];
    }


}
