<?php

namespace App\Http\Controllers\Apis;

use App\Http\Controllers\Controller;
use App\Http\Resources\AboutStructResource;
use App\Http\Resources\AboutUSResource;
use App\Http\Resources\PartnerResource;
use App\Models\Dashboard\AboutStruct;
use App\Models\Dashboard\AboutUs;
use App\Models\Partener;
use App\Models\Section;
use App\View\Composers\SeoComposer ;


class AboutController extends Controller
{
    private $sections ;
    public function __construct(){
        $this->sections = Section::get();
    }
    public function index()
    {
        SeoComposer::renderSeo();

        $data = [
            'seo' => config('seo'),
            'success' => true,
            'message' => '',
            'data' => [
                'about' => $this->getAboutSection(),
                'about_structs' => $this->getAboutStructsSection(),
                'partners' => $this->getPartnersSection(),
            ]
        ];

        return response()->json(
            $data ,
            200,
            
        );
    }


    public function getAboutSection()
    {
        $about = AboutUs::first();
        return ['data' => $about ? new AboutUSResource($about): null ];

    }

    public function getAboutStructsSection(){
        $struct = AboutStruct::active()->get();
        return ['data' => AboutStructResource::collection($struct)];
    }



    public function getPartnersSection()
    {
        $section = $this->sections->firstWhere('key' , 'partners');
        $partners = Partener::active()->get();

        return [
            'title' => $section->title ?? null,
            'short_desc' => $section->short_desc ?? null,
            'data' => PartnerResource::collection($partners)
        ];
    }

}
