# PWA Setup Guide - دليل إعداد PWA

## ✅ PWA جاهز للعمل تلقائياً!

### المميزات:
- **ديناميكي 100%**: يعمل مع أي موقع جديد بدون تعديل
- **اكتشاف تلقائي للمسار**: يكتشف subdirectory تلقائياً
- **دعم متعدد اللغات**: عربي وإنجليزي
- **أيقونات مخصصة**: SVG عالية الجودة
- **Service Worker**: يعمل في الخلفية

### كيفية العمل:

#### 1. للمواقع الجديدة:
```bash
# مثال: موقع جديد في /new-site/public/
# PWA سيعمل تلقائياً مع:
# - start_url: "/new-site/public/ar"
# - scope: "/new-site/public/"
# - shortcuts: "/new-site/public/ar/services"
```

#### 2. للمواقع الموجودة:
```bash
# مثال: موقع في /existing-site/
# PWA سيعمل تلقائياً مع:
# - start_url: "/existing-site/ar"
# - scope: "/existing-site/"
# - shortcuts: "/existing-site/ar/services"
```

### الملفات المطلوبة:
- ✅ `app/Http/Controllers/ManifestController.php` - Controller ديناميكي
- ✅ `routes/web.php` - Route لـ manifest.json
- ✅ `resources/views/components/website/partials/_head.blade.php` - HTML head
- ✅ `resources/views/components/website/partials/_script.blade.php` - JavaScript
- ✅ `public/assets/website/images/icon-*.svg` - الأيقونات
- ✅ `public/sw.js` - Service Worker

### الاختبار:
```bash
# 1. تشغيل الخادم
php artisan serve --host=0.0.0.0 --port=8000

# 2. فتح الموقع
http://localhost:8000

# 3. فحص manifest
http://localhost:8000/manifest.json

# 4. فحص PWA في Chrome
# Developer Tools > Application > Manifest
```

### للإنتاج:
- تأكد من أن الموقع يعمل على HTTPS
- PWA سيعمل تلقائياً مع أي مسار
- أيقونة التنزيل ستظهر في شريط العنوان

### ملاحظات:
- لا حاجة لتعديل أي ملف عند إنشاء موقع جديد
- URLs تتولد تلقائياً حسب مسار الموقع
- يدعم subdirectories متعددة المستويات
- يعمل مع Laravel routes و localization

## 🎉 PWA جاهز للاستخدام!
