    <!--<< All JS Plugins >>-->
    <script src="{{ Path::js('jquery-3.7.1.min.js') }}" defer></script>
    <!--<< Viewport Js >>-->
    <script src="{{ Path::js('viewport.jquery.js') }}" defer></script>
    <!--<< Bootstrap Js >>-->
    <script src="{{ Path::js('bootstrap.bundle.min.js') }}" defer></script>
    <!--<< Gsap Js >>-->
    <script src="{{ Path::js('gsap/gsap.js') }}" defer></script>
    <!--<< Gsap Scroll To Pluging Js >>-->
    <script src="{{ Path::js('gsap/gsap-scroll-to-plugin.js') }}" defer></script>
    <!--<< Gsap Scroll Smoother Js >>-->
    <script src="{{ Path::js('gsap/gsap-scroll-smoother.js') }}" defer></script>
    <!--<< Gsap Scroll Trigger Js >>-->
    <script src="{{ Path::js('gsap/gsap-scroll-trigger.js') }}" defer></script>
    <!--<< Gsap Split Text Js >>-->
    <script src="{{ Path::js('gsap/gsap-split-text.js') }}" defer></script>
    <!--<< Nice Select Js >>-->
    <script src="{{ Path::js('jquery.nice-select.min.js') }}" defer></script>
    <!--<< Waypoints Js >>-->
    <script src="{{ Path::js('jquery.waypoints.js') }}" defer></script>
    <!--<< Counterup Js >>-->
    <script src="{{ Path::js('jquery.counterup.min.js') }}" defer></script>
    <!--<< Swiper Slider Js >>-->
    <script src="{{ Path::js('swiper-bundle.min.js') }}" defer></script>
    <!--<< MeanMenu Js >>-->
    <script src="{{ Path::js('jquery.meanmenu.min.js') }}" defer></script>
    <!--<< Magnific Popup Js >>-->
    <script src="{{ Path::js('jquery.magnific-popup.min.js') }}" defer></script>
    <!--<< WOW Animation Js >>-->
    <script src="{{ Path::js('wow.min.js') }}" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-element-bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.umd.js"></script>
    <!--<< Main.js >>-->
    <script src="{{ Path::js('main.js') }}" defer></script>


    <script>
      Fancybox.bind('[data-fancybox="gallery"]', {
    Thumbs: {
      autoStart: true,
    },
  });
        let recaptchaLoaded = false;

        function loadRecaptcha() {
            if (recaptchaLoaded) return;
            recaptchaLoaded = true;

            const script = document.createElement('script');
            script.src = "https://www.google.com/recaptcha/api.js?onload=onRecaptchaLoadCallback&render=explicit";
            script.async = true;
            script.defer = true;
            document.body.appendChild(script);
        }

        function onRecaptchaLoadCallback() {
            grecaptcha.render(document.querySelector('.g-recaptcha'), {
                'sitekey': "{{ config('captcha.sitekey') }}"
            });
        }

        document.addEventListener("DOMContentLoaded", function() {
            const form = document.querySelector(".contact-form");
            if (form) {
                form.addEventListener("focusin", loadRecaptcha, {
                    once: true
                });
            }
        });
    </script>

    {{-- PWA Service Worker Registration --}}
    <script>
        // PWA Service Worker Registration
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('{{ asset('sw.js') }}').then(function(registration) {
                    console.log('✅ PWA: Service Worker registered successfully');

                    // Check for updates
                    registration.addEventListener('updatefound', () => {
                        const newWorker = registration.installing;
                        if (newWorker) {
                            newWorker.addEventListener('statechange', () => {
                                if (newWorker.state === 'installed' && navigator
                                    .serviceWorker.controller) {
                                    console.log('🔄 PWA: New version available');
                                    // You can show a notification here
                                }
                            });
                        }
                    });
                }).catch(function(error) {
                    console.log('❌ PWA: Service Worker registration failed:', error);
                });
            });
        }

        // PWA Install Prompt Handler
        let deferredPrompt;
        let installButton;

        // Debug PWA readiness
        console.log('🔍 PWA Debug Info:');
        console.log('- Service Worker Support:', 'serviceWorker' in navigator);
        console.log('- Current URL:', window.location.href);
        console.log('- Is HTTPS or localhost:', window.location.protocol === 'https:' || window.location.hostname ===
            'localhost');

        window.addEventListener('beforeinstallprompt', (e) => {
            console.log('📱 PWA: Install prompt triggered!');
            console.log('📱 PWA: Event details:', e);

            // Prevent Chrome 67 and earlier from automatically showing the prompt
            e.preventDefault();

            // Stash the event so it can be triggered later
            deferredPrompt = e;

            // Show install button or banner immediately
            showInstallPrompt();

            // Also show a console message
            console.log('✅ PWA: Ready for installation!');
        });

        // Force show install button for testing (remove in production)
        setTimeout(() => {
            if (!deferredPrompt) {
                console.log('⚠️ PWA: No install prompt detected after 3 seconds');
                console.log('⚠️ PWA: This might be because:');
                console.log('- App is already installed');
                console.log('- PWA criteria not met');
                console.log('- Browser doesn\'t support PWA install');

                // Show button anyway for testing
                showInstallPrompt();
            }
        }, 3000);

        function showInstallPrompt() {
            console.log('🔧 PWA: Creating install button...');

            // Create install button if it doesn't exist
            if (!installButton) {
                installButton = document.createElement('button');
                installButton.innerHTML = '📱 تثبيت التطبيق';
                installButton.className = 'pwa-install-btn';
                installButton.style.cssText = `
                    position: fixed;
                    bottom: 20px;
                    right: 20px;
                    background: linear-gradient(135deg, #007bff, #0056b3);
                    color: white;
                    border: none;
                    padding: 15px 25px;
                    border-radius: 30px;
                    font-size: 16px;
                    font-weight: 600;
                    cursor: pointer;
                    box-shadow: 0 6px 20px rgba(0,123,255,0.4);
                    z-index: 10000;
                    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
                    transition: all 0.3s ease;
                    animation: pulse 2s infinite;
                `;

                // Add pulse animation
                const style = document.createElement('style');
                style.textContent = `
                    @keyframes pulse {
                        0% { transform: scale(1); }
                        50% { transform: scale(1.05); }
                        100% { transform: scale(1); }
                    }
                    .pwa-install-btn:hover {
                        transform: translateY(-3px) scale(1.05) !important;
                        box-shadow: 0 8px 25px rgba(0,123,255,0.5) !important;
                    }
                `;
                document.head.appendChild(style);

                installButton.addEventListener('click', installApp);
                document.body.appendChild(installButton);

                console.log('✅ PWA: Install button created and added to page');
            }

            // Show the button
            installButton.style.display = 'block';
            installButton.style.opacity = '1';

            console.log('👁️ PWA: Install button is now visible');

            // Auto-hide after 15 seconds instead of 10
            setTimeout(() => {
                if (installButton && installButton.style.display !== 'none') {
                    console.log('⏰ PWA: Auto-hiding install button...');
                    installButton.style.opacity = '0.6';
                    installButton.style.animation = 'none'; // Stop pulsing

                    setTimeout(() => {
                        if (installButton) {
                            installButton.style.display = 'none';
                            console.log('🙈 PWA: Install button hidden');
                        }
                    }, 8000);
                }
            }, 15000);
        }

        function installApp() {
            console.log('🎯 PWA: Install button clicked!');

            if (deferredPrompt) {
                console.log('📱 PWA: Using native install prompt');

                // Hide the install button
                installButton.style.display = 'none';

                // Show the prompt
                deferredPrompt.prompt();

                // Wait for the user to respond to the prompt
                deferredPrompt.userChoice.then((choiceResult) => {
                    console.log('📊 PWA: User choice:', choiceResult.outcome);

                    if (choiceResult.outcome === 'accepted') {
                        console.log('🎉 PWA: User accepted the install prompt');
                    } else {
                        console.log('😔 PWA: User dismissed the install prompt');
                        // Show button again after 2 minutes if dismissed
                        setTimeout(() => {
                            console.log('🔄 PWA: Showing install button again after dismissal');
                            showInstallPrompt();
                        }, 2 * 60 * 1000);
                    }
                    deferredPrompt = null;
                });
            } else {
                console.log('⚠️ PWA: No deferred prompt available');
                console.log('💡 PWA: Showing manual install instructions');

                // Show manual install instructions
                alert('لتثبيت التطبيق:\n\n' +
                    '• Chrome: اضغط على القائمة (⋮) → "تثبيت التطبيق"\n' +
                    '• Safari: اضغط على مشاركة → "إضافة إلى الشاشة الرئيسية"\n' +
                    '• Edge: اضغط على القائمة (⋯) → "تثبيت التطبيق"');
            }
        }

        // Handle successful installation
        window.addEventListener('appinstalled', (evt) => {
            console.log('🎉 PWA: App was successfully installed');
            if (installButton) {
                installButton.remove();
                installButton = null;
            }
        });

        // iOS Safari specific PWA detection
        function isIOSDevice() {
            return /iPad|iPhone|iPod/.test(navigator.userAgent);
        }

        function isInStandaloneMode() {
            return window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone === true;
        }

        // Show iOS install instructions
        if (isIOSDevice() && !isInStandaloneMode()) {
            setTimeout(() => {
                // You can show iOS-specific install instructions here
                console.log('📱 iOS: Show install instructions');
            }, 3000);
        }
    </script>
