@if ($blogs->isNotEmpty())
    <!--===============Blogs==============-->
    <section class="blog-section py-5  bg-cover"
        style="background-image: url('{{ Path::imgPath('news/bg.png') }}');">
        <div class="container py-5">
            @foreach ($sections as $section)
                @if ($section->key == 'blogs')
                    <div class="section-title text-center">
                        <h6 class="wow fadeInUp">{{ $section->title }}</h6>
                        <h2 class="wow fadeInUp" data-wow-delay=".3s">
                            {{ $section->second_title }}
                        </h2>
                    </div>
                @endif
            @endforeach
            <div class="blog-wrapper">
                <div class="row">
                    @foreach ($blogs as $blog)
                        <div class="col-xl-4 col-lg-6 col-md-6 wow img-custom-anim-top" data-wow-duration="1.5s"
                            data-wow-delay="0.1s">
                            <div class="blog-box-items">
                                 <a href="{{ $blog->link }}">
                                <div class="blog-image">
                                    <img src="{{ $blog->image_path }}" alt="{{ $blog->name }}">
                                    <img src="{{ $blog->image_path }}" alt="{{ $blog->name }}">
                                </a>
                                </div>
                                <div class="blog-content">
                                    <h3>
                                        <a href="{{ $blog->link }}">{{ $blog->name }}</a>
                                    </h3>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="news-button text-center mt-5 wow fadeInUp" data-wow-delay=".3s">
                    <a href="{{ Path::AppUrl('blogs') }}" class="theme-btn">{{ trans('website.all_blogs') }}</a>
                </div>
            </div>
        </div>
    </section>
    <!--===============Blogs==============-->
@endif
