<x-dashboard.layout :title="__('dashboard.projects')">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">{{ __('dashboard.projects') }}</h4>

                    <div class="page-title-right d-flex align-items-center">
                        <div class="btn btn-list">
                            <a href="{{ route('dashboard.projects.create') }}" class="btn ripple btn-primary">
                                <i class="fas fa-plus-circle"></i> {{ __('dashboard.add') }}
                            </a>
                            <button id="btn_active" class="btn ripple btn-dark">
                                <i class="fas fa-eye"></i> {{ __('dashboard.publish/unpublish') }}
                            </button>
                            <button id="btn_delete" class="btn ripple btn-danger">
                                <i class="fas fa-trash"></i> {{ __('dashboard.delete') }}
                            </button>
                        </div>

                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard.home') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ __('dashboard.projects') }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Table -->
        <div class="row">
            <div class="col-12">
                <div class="dashboard-table-container">
                    <div class="card-header">
                        <h4>{{ __('dashboard.projects') }}</h4>
                    </div>
                    <div class="card-body">
                        <table id="datatable-buttons" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 50px;">
                                        <input type="checkbox" id="checkAll" class="form-check-input">
                                    </th>
                                    <th>{{ __('dashboard.id') }}</th>
                                    <th>{{ __('dashboard.name_en') }}</th>
                                    <th>{{ __('dashboard.name_ar') }}</th>
                                    <th>{{ __('dashboard.order') }}</th>
                                    <th>{{ __('dashboard.image') }}</th>
                                    <th>{{ __('dashboard.parent') }}</th>
                                    <th>{{ __('dashboard.status') }}</th>
                                    <th>{{ __('dashboard.actions') }}</th>
                                </tr>
                            </thead>


                            <tbody>
                                @foreach ($projects as $project)
                                    <tr id="{{ $project->id }}">
                                        <td class="text-center">
                                            <input type="checkbox" name="checkbox" class="check-inputs form-check-input"
                                                value="{{ $project->id }}">
                                        </td>
                                        <td><a
                                                href="{{ route('dashboard.projects.edit', $project->id) }}">{{ $project->id }}</a>
                                        </td>
                                        <td><a
                                                href="{{ route('dashboard.projects.edit', $project->id) }}">{{ $project->getTranslation('name', 'en') }}</a>
                                        </td>
                                        <td><a
                                                href="{{ route('dashboard.projects.edit', $project->id) }}">{{ $project->getTranslation('name', 'ar') }}</a>
                                        </td>

                                        <td><a
                                                href="{{ route('dashboard.projects.edit', $project->id) }}">{{ $project->order }}</a>
                                        </td>
                                        <td>
                                            <a href="{{ route('dashboard.projects.edit', $project->id) }}">
                                                <img src="{{ $project->image_path }}" width="70">
                                            </a>
                                        </td>
                                        <td>
                                            <a href="{{ route('dashboard.projects.edit', $project->id) }}">
                                                @if ($project->parent_id && $project->parent)
                                                    {{ $project->parent->getTranslation('name', 'ar') }}
                                                @else
                                                    <span class="text-muted">{{ __('dashboard.no_parent') }}</span>
                                                @endif
                                            </a>
                                        </td>
                                        <td>
                                            @if ($project->status == 1)
                                                <span class="badge bg-success">{{ __('dashboard.yes') }}</span>
                                            @else
                                                <span class="badge bg-danger">{{ __('dashboard.no') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('dashboard.projects.edit', $project->id) }}"
                                                class="btn btn-sm btn-primary" title="{{ __('dashboard.edit') }}">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button"
                                                class="btn-action {{ $project->status ? 'btn-success' : 'btn-secondary' }} toggle-status-btn"
                                                data-id="{{ $project->id }}" data-status="{{ $project->status }}"
                                                title="{{ __('dashboard.toggle_visibility') }}">
                                                <i class="fas fa-eye{{ $project->status ? '' : '-slash' }}"></i>
                                            </button>
                                            <form action="{{ route('dashboard.projects.destroy', $project->id) }}"
                                                method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"
                                                    title="{{ __('dashboard.delete') }}"
                                                    onclick="return confirm('هل أنت متأكد من الحذف؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- end cardaa -->
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div>


    @push('scripts')
        <script>
            $(document).ready(function() {
                // التحقق من أن الجدول لم يتم تهيئته مسبقاً
                if (!$.fn.DataTable.isDataTable('#datatable-buttons')) {
                    // تهيئة الجدول البسيط
                    $('#datatable-buttons').DataTable({
                        "responsive": true,
                        "autoWidth": false,
                        "pageLength": 25,
                        "language": {
                            "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
                        }
                    });
                }

                // checkboxes بسيط
                $('#checkAll').on('click', function() {
                    $('.check-inputs').prop('checked', this.checked);
                });

                $('.check-inputs').on('click', function() {
                    var totalCheckboxes = $('.check-inputs').length;
                    var checkedCheckboxes = $('.check-inputs:checked').length;
                    $('#checkAll').prop('checked', totalCheckboxes === checkedCheckboxes);
                });

                // Toggle status functionality
                $('.toggle-status-btn').on('click', function() {
                    var button = $(this);
                    var projectId = button.data('id');
                    var currentStatus = button.data('status');
                    var newStatus = !currentStatus;

                    // Show loading state
                    button.prop('disabled', true);
                    var originalIcon = button.find('i').attr('class');
                    button.find('i').attr('class', 'fas fa-spinner fa-spin');

                    $.ajax({
                        url: "{{ route('dashboard.projects.toggleStatus', 0) }}".replace('0',
                            projectId),
                        type: 'POST',
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            if (response.success) {
                                // Update button appearance
                                button.data('status', newStatus);
                                if (newStatus) {
                                    button.removeClass('btn-secondary').addClass('btn-success');
                                    button.find('i').attr('class', 'fas fa-eye');
                                } else {
                                    button.removeClass('btn-success').addClass('btn-secondary');
                                    button.find('i').attr('class', 'fas fa-eye-slash');
                                }

                                // Update status badge in the same row
                                var row = button.closest('tr');
                                var statusCell = row.find('td:nth-child(8)'); // Status column
                                if (newStatus) {
                                    statusCell.html(
                                        '<span class="badge bg-success">{{ __('dashboard.yes') }}</span>'
                                    );
                                } else {
                                    statusCell.html(
                                        '<span class="badge bg-danger">{{ __('dashboard.no') }}</span>'
                                    );
                                }

                                // Show success message
                                toastr.success(response.message);
                            } else {
                                toastr.error(response.message || 'حدث خطأ في تحديث الحالة');
                            }
                        },
                        error: function(xhr) {
                            var errorMessage = 'حدث خطأ في تحديث الحالة';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        },
                        complete: function() {
                            // Restore button state
                            button.prop('disabled', false);
                        }
                    });
                });
            });
        </script>
    @endpush

    @section('script')
    @endsection
</x-dashboard.layout>
